param([string]$InstanceName, [int]$TimePeriod, [string]$CustomSQLName)

if ($TimePeriod -gt 0)
{
$StrLength = 4096

if ($CustomSQLName){$ComputerName=$CustomSQLName}
else {$ComputerName=(Get-WmiObject Win32_Computersystem).name}

if ($InstanceName -match "SQLServer"){$InstanceName = ""}
else {$InstanceName = $InstanceName.Replace('MSSQL$',"")
	$InstanceName = $InstanceName.Replace("'","")
}

$ConnectionString = $ComputerName + '\' + $InstanceName
#write-output "ConnString - $ConnectionString"

$Query = @"
DECLARE @TimeIntervalMinutes int = $TimePeriod

;WITH a AS
(
SELECT
d.name AS DatabaseName
,mf.name AS LogFile
,mf.size * 8 / 1024 AS [Size, Mb]
,CAST(mf.max_size AS bigint) * 8 / 1024 AS [Max Size, Mb]
,CASE WHEN mf.is_percent_growth = 1 THEN mf.growth END AS [AuthGrowth, %]
,CASE WHEN mf.is_percent_growth = 0 THEN CAST(mf.growth AS bigint) * 8 / 1024 END AS [AuthGrowth, Mb]
,recovery_model_desc
,log_reuse_wait_desc
FROM
sys.master_files mf
join sys.databases d ON mf.database_id = d.database_id
WHERE 1 = 1
AND d.name NOT IN ('master','model','msdb','tempdb')
AND d.name LIKE 'ComplyTrack%'
AND d.name NOT IN ('ComplyTrackSessionState')
AND mf.type_desc = 'LOG'
)
SELECT
*
FROM
a
WHERE [Max Size, Mb] NOT IN (2048, 4096)
OR recovery_model_desc = 'SIMPLE'
OR [AuthGrowth, %] IS NOT NULL
OR [AuthGrowth, Mb] NOT IN (128, 256)
OR [Size, Mb] > [Max Size, Mb]
ORDER BY
DatabaseName
,LogFile
"@
try{
    $Datatable = New-Object System.Data.DataTable
    
    $Connection = New-Object System.Data.SQLClient.SQLConnection
    $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;"
    $Connection.Open()
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $Connection
    $Command.CommandText = $Query
    $Reader = $Command.ExecuteReader()
    $Datatable.Load($Reader)
    $Connection.Close()
 
#    $Datatable.Rows | FT *


if (($Datatable.rows).count -ge 1)
{
    $FormatedData = $Datatable.Rows | FT | out-string
    if($FormatedData.Length -gt $StrLength) {$FormatedData = $FormatedData.substring(0, $StrLength)}
    write-output $FormatedData
}
else{write-output "Result: none"}
}

Catch
{write-output "Result: none"
$ConnectionString
$Exception = $_.Exception.Message
if($Exception.Length -gt $StrLength) {$Exception = $Exception.substring(0, $StrLength)}
write-output $Exception
}
}
else{write-output "Result: none"}