param([string]$InstanceName, [int]$TimePeriod, [string]$CustomSQLName, [string]$Exclude)

# Escape single quote (just in case)
if ($Exclude -match "'") {
    $Exclude = $Exclude -replace "'", "''"
}

if ($Exclude -match "#") {
    
    [array]$ExcludeArray = $Exclude -split "#"
    [array]$Exclude = @()

    # Transform exclude list of jobs with delimeter into an array with elements each enclosed in single quotes
    Try {
        foreach ($Element in $ExcludeArray) {
            # Enclose each job name in single quotes
            $Exclude += "'$Element'"
        }

        # Create a string that will be inserter in query
        [string]$ExcludeString = $Exclude -join ","
    }
    Catch {
        $Exception = $_.Exception
        Throw "Failed to transform exclude list:`n$($Exception.Message)"
    }
}
else {
    $ExcludeString = "'$Exclude'"
}

if ($TimePeriod -gt 0) {
    $StrLength = 4096

    if ($CustomSQLName) { $ComputerName = $CustomSQLName }
    else { $ComputerName = (Get-WmiObject Win32_Computersystem).name }

    if ($InstanceName -like "SQLServer") { $InstanceName = "" }
    else {
        $InstanceName = $InstanceName.Replace('MSSQL$', "")
        $InstanceName = $InstanceName.Replace("'", "")
    }

    $ConnectionString = $ComputerName + '\' + $InstanceName

    $Query = @"
DECLARE @TimeIntervalMinutes int = $TimePeriod

;with h as
(
select
job_id,
step_id,
step_name,
DATEADD(hh, run_time/10000, DATEADD(mi, run_time%10000/100, DATEADD(ss, run_time%100, CONVERT(datetime, CAST(run_date as varchar(8)))))) as run_date,
run_duration/10000 as run_duration_hh,
run_duration%10000/100 as run_duration_mi,
run_duration%100 as run_duration_ss
from
msdb.dbo.sysjobhistory
where run_status = 0
)
, b as
(
select
j.name as job_name,
s.step_id,
h.step_name,
h.run_date,
h.run_duration_hh/24 as run_duration_dd,
DATEADD(hh, h.run_duration_hh, DATEADD(mi, h.run_duration_mi, DATEADD(ss, h.run_duration_ss, h.run_date))) as end_date,
DATEADD(hh, h.run_duration_hh, DATEADD(mi, h.run_duration_mi, DATEADD(ss, h.run_duration_ss, 0))) as run_duration_DDHHMMSS
from
h
JOIN msdb.dbo.sysjobs j ON h.job_id = j.job_id
JOIN msdb.dbo.sysjobsteps s ON j.job_id = s.job_id AND h.step_id = s.step_id
)
select
job_name,
step_name,
CONVERT(varchar(20), run_date, 120) as run_date,
CASE WHEN run_duration_dd > 0 THEN CAST(run_duration_dd as varchar(3)) + ':' ELSE '' END + CONVERT(varchar(8), run_duration_DDHHMMSS, 108) as run_duration
from
b
where DATEDIFF(mi, end_date, GETDATE()) <= @TimeIntervalMinutes
and job_name not in ($ExcludeString)
order by run_date, job_name, step_id
"@
    try {
        $Datatable = New-Object System.Data.DataTable
    
        $Connection = New-Object System.Data.SQLClient.SQLConnection
        $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;"
        $Connection.Open()
        $Command = New-Object System.Data.SQLClient.SQLCommand
        $Command.Connection = $Connection
        $Command.CommandText = $Query
        $Reader = $Command.ExecuteReader()
        $Datatable.Load($Reader)
        $Connection.Close()
 

        if (($Datatable.rows).count -ge 1) {
            $FormatedData = $Datatable.Rows | select-object Job_Name, step_name, run_date, run_duration | FL | out-string
            if ($FormatedData.Length -gt $StrLength) { $FormatedData = $FormatedData.substring(0, $StrLength) }
            write-output $FormatedData
        }

        else { write-output "Result: none" }
    }
    Catch {
        write-output "Result: none"
        $ConnectionString
        $Exception = $_.Exception.Message
        if ($Exception.Length -gt $StrLength) { $Exception = $Exception.substring(0, $StrLength) }
        write-output $Exception
    }
}
else { write-output "Result: none" }