param ([int64]$DefWarnTHR, [int64]$DefCritTHR, [int64]$DefWarnTHRBytes,[int64]$DefCritTHRBytes, [string]$DrivesTHR, [string]$ExcludeDrives)

$ExcludeArray = $ExcludeDrives.split('#')

[array]$Drives = get-wmiobject win32_volume | ? { $_.DriveType -eq 3 } | Select-Object -ExpandProperty "DriveLetter" | Where-Object { $_ -notin $ExcludeArray }

$THRArray = $DrivesTHR.split("#")

$idx = 1
write-output "{"
write-output " `"data`":["

for ($i = 0; $i -lt $Drives.count; $i++)
{
    $CurrentWarnTHR = $DefWarnTHR
    $CurrentCritTHR = $DefCritTHR
    $CurrentWarnTHRBytes = $DefWarnTHRBytes
    $CurrentCritTHRBytes = $DefCritTHRBytes

    foreach ($THRItem in $THRArray)
        {
        $Data = $THRItem.split("~")
         if ($Data[0] -eq $Drives[$i]){$CurrentWarnTHR = $Data[1]; $CurrentCritTHR = $Data[2];$CurrentWarnTHRBytes = $Data[3]; $CurrentCritTHRBytes = $Data[4]}
        }

    if ($idx -lt $Drives.count)
    {
     
        $line= "{ `"{#FSNAME}`" : `"" + $Drives[$i] + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREEBYTESWARNING}`" : `"" + $CurrentWarnTHRBytes + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREEBYTESCRITICAL}`" : `"" + $CurrentCritTHRBytes + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREESPACE}`" : `"" + $CurrentWarnTHR + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREESPACECRIT}`" : `"" + $CurrentCritTHR + "`"} ,"
        write-output $line
    }
    elseif ($idx -ge $Drives.count)
    {
   
        $line= "{ `"{#FSNAME}`" : `"" + $Drives[$i] + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREEBYTESWARNING}`" : `"" + $CurrentWarnTHRBytes + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREEBYTESCRITICAL}`" : `"" + $CurrentCritTHRBytes + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREESPACE}`" : `"" + $CurrentWarnTHR + "`" ,"
        write-output $line
        $line= " `"{#THR_DISKFREESPACECRIT}`" : `"" + $CurrentCritTHR + "`"}"
        write-output $line
    }
    $idx++;


}
write-output " ]"
write-output "}"